<title><?php echo e($user->name); ?> - Best Leearning</title>

<?php $__env->startSection('css'); ?>
 <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="akota microjobs/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="akota microjobs/resources/css/myapp.css" type="text/css">
    <style>
        .cust_task_working .row {
    		border: 1px solid #eaeaea;
    		border-radius: 3px;
    		padding: 2px;
    	}
        .bg-gradient-green {
            background: linear-gradient(87deg,#2dce89 0,#2dcecc 100%)!important;
        }
        .bg-gradient-info {
            background: linear-gradient(87deg,#11cdef 0,#1171ef 100%)!important;
        }
        .icon-shape {
            display: inline-flex;
            /* padding: 12px; */
            text-align: center;
            border-radius: 50%;
            align-items: center;
            justify-content: center;
        }
        .icon {
            width: 3rem;
            height: 3rem;
        }
        .icon-shape i, .icon-shape svg {
            font-size: 1.25rem;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('user-content'); ?>
   <div class="row mt-2">
	   <div class="col-xl-4 order-xl-2">
	    	<div class="card card-profile">
                <img src="https://actupjob.com/backend/img/website/testimage.jpg" alt="Image Placeholder" class="card-img-top">
                <div class="row justify-content-center">
    				<div class="col-lg-3 order-lg-2">
    					<div class="card-profile-image">
    						<a href="#">
                                <?php if(file_exists($user->image)): ?>
                                    <img src="<?php echo e(URL::to($user->image)); ?>" alt="<?php echo e($user->name); ?>" class="img-fluid img-thumbnail rounded-circle avatar-lg" style="width: 120px; height: 120px;">
                                <?php else: ?>
                                    <img class="rounded-circle" src="<?php echo e(asset('frontend/img/user.png')); ?>" alt="User Image" width="120px" height="120px">
                                <?php endif; ?>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-header text-center border-0 pt-5 pt-md-4 pb-0 pb-md-4"></div>
        			<div class="card-body">
        				<div class="text-center">
        				    <h5 class="h2"><?php echo e($user->name); ?>

        				    <?php if($user->premium_status == 0): ?>
                                <a class="btn btn-sm" style="background-color: transparent; border: 1px solid black; color: black; font-weight: bold; font-size: 6px;">
                                    <i class="fas fa-times-circle"></i> Not Verified
                                </a>
                            <?php else: ?>
                                <i class="fas fa-check-circle"></i>
                            <?php endif; ?> 
        				    </h5>
                    		<p class="drk-bg-one"><span style='background: #eaeaea;border-radius:5px;padding:2px 5px 2px 5px'><?php echo e(user_work_rating($user->id)); ?> Reviews (<?php echo e(user_rating($user->id)); ?>) <?php if(user_rating($user->id) >= 2.5): ?><i class="fa fa-star checked" style="color:#F37205"></i><?php endif; ?></span></p>
        					<?php if(session('user_age')): ?>
        					<p class="text-muted">I&#039;m <?php echo e(session('user_age')); ?> years old</p>
        					<?php endif; ?>
        					<p class="text-muted">Since  <?php echo e(\Carbon\Carbon::parse($user->created_at)->format('d M, y')); ?></p>
        					<?php if(user_activity($user->id) == 1): ?>
        					<small class="text-muted"><span style='color:#239B56;'> I'm online </span></small>
        					<?php else: ?>
        					<small class="text-muted"><span style='color:#a2240b;'> I'm offline </span></small>
        					<?php endif; ?>
        					<div class="h5 font-weight-300">
        						<h4>User ID: <?php echo e(user_code($user->id)); ?></h4>
        						<span class='text'><i class='fas fa-globe'></i> <?php echo e(country($user->country)); ?> - <?php echo e(user_phone($user->id)); ?></span>
        					</div><br>
        					<a class="btn btn-sm" style="background-color: transparent; border: 1px solid dodgerblue; color: dodgerblue; font-weight: bold; font-size: 8px;">Default</a>
                       </div>
                   </div>
            </div>
            <!-- end card -->
            <?php
                $work_sutisfied = work_approve_ratio($user->id);
                $job_sutisfied = job_approve_ratio($user->id);
            ?>
            
            <div class="card bg-gradient-green border-0">
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col">
                            <h5 class="h3 mb-0 text-white">WORK RATED</h5>
                            <h5 class="h3 mb-1 text-white"><?php echo e(total_attend_work($user->id)); ?></h5>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-white text-dark rounded-circle shadow">
    							<i class="fas fa-tasks"></i>
    						</div>
                        </div>
                    </div>
                    <p class="mt-3 mb-0 text-sm">
    					<span class="text-white mr-2 font-weight-500"><i class="fa fa-percentage"></i> <?php echo e(number_format($work_sutisfied, 0)); ?>%</span>
    					<span class="text-nowrap text-light font-weight-500">Satisfaction</span>
    				</p>
                </div>
            </div>
            
            <div class="card bg-gradient-info">
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col">
                            <h5 class="h3 mb-0 text-white">JOB</h5>
                            <h5 class="h3 mb-1 text-white"><?php echo e(user_total_job($user->id)); ?></h5>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-white text-dark rounded-circle shadow">
    							<i class="fas fa-briefcase"></i>
    						</div>
                        </div>
                    </div>
                    <p class="mt-3 mb-0 text-sm">
    					<span class="text-white mr-2 font-weight-500"><i class="fa fa-percentage"></i> <?php echo e(total_ratio_by_user($user->id)); ?>%</span>
    					<span class="text-nowrap text-light font-weight-500">Satisfied</span>
    				</p>
                </div>
            </div>
        </div>
        <div class="col md-6">
            <div class="row justify-content-center">
                <div class="">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="surtitle">Overview</h6>
                            <h5 class="h3 mb-0">Total Working</h5>
                        </div>
                        <div class="card-body cust_task_working">
                            <div class="row mb-2">
                                <div class="col-6">Task Attend</div>
                                <div class="col-6 text-primary h2"><?php echo e(total_attend_work($user->id)); ?></div>
                            </div>
                            <div class="row mb-2">
                                <div class="col-6">Satisfied <br> <h6>Approved in task</h6></div>
                                <div class="col-6 text-success h2"><?php echo e(user_complete_job_approve($user->id)); ?></div>
                            </div>
                            <div class="row mb-2">
                                <div class="col-6">Not Satisfied<br><h6>Rejected in task prove</h6></div>
                                <div class="col-6 text-danger h2"><?php echo e(user_complete_job_reject($user->id)); ?></div>
                            </div>
                            <div class="row mb-2">
                                <div class="col-6">Pending <br><h6>In review for rating</h6></div>
                                <div class="col-6 text-info h2"><?php echo e(user_complete_job_pending($user->id)); ?></div>
                            </div>
                            <div class="row mb-2">
    							<div class="col-6">Last Task</div>
    							<div class="col-6 text-info h3"><?php if(last_worked_job($user->id)): ?>
            <?php echo e(\Carbon\Carbon::parse(last_worked_job($user->id)->created_at)->format('j M, y')); ?>

        <?php endif; ?>
    							</div>
    						</div>
                        </div>
                    </div>
               </div>
            
                <div class="row">
                    <div class="col-lg-6 col-md-6 col-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="text-center">Working Status</h4>
                                <div>
                                    <canvas id="working_status" style="width="320" height="320"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-6 col-md-6 col-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="text-center">Job Status</h4>
                                <div>
                                    <canvas id="job_status" style="width="320" height="320"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
           </div>
       </div>
   </div>
<?php
    $work_sutisfied = work_approve_ratio($user->id);
    $work_pending = work_pending_ratio($user->id);
    $work_reject = work_reject_ratio($user->id);
   
    $job_sutisfied =  job_approve_ratio($user->id);
    $job_pending =  job_pending_ratio($user->id);
    $job_reject =  job_reject_ratio($user->id);
   
?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js"></script>
    <script>
    var xValues = ["Satisfied", "Unsatisfied", "Pending", "NotRated"];
    var workValues = [<?php echo e($work_sutisfied); ?>, <?php echo e($work_reject); ?>, <?php echo e($work_pending); ?>];
    var jobValues = [<?php echo e($job_sutisfied); ?>, <?php echo e($job_reject); ?>, <?php echo e($job_pending); ?>];
    var barColors = [
        "#00aba9",
        "#b91d47",
        "#f5c242",
        "#BDC3C7"
    ];

    // Calculate the NotRated value dynamically
    var workNotRated = 100 - (workValues.reduce((acc, val) => acc + val, 0));
    var jobNotRated = 100 - (jobValues.reduce((acc, val) => acc + val, 0));

    workValues.push(workNotRated);
    jobValues.push(jobNotRated);

    new Chart("working_status", {
        type: "doughnut",
        data: {
            labels: xValues,
            datasets: [{
                backgroundColor: barColors,
                data: workValues
            }]
        },
        options: {
            title: {
                display: true
            }
        }
    });

    new Chart("job_status", {
        type: "doughnut",
        data: {
            labels: xValues,
            datasets: [{
                backgroundColor: barColors,
                data: jobValues
            }]
        },
        options: {
            title: {
                display: true
            }
        }
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealruom/microjob.dealingwork.com/resources/views/user/pages/user-profile.blade.php ENDPATH**/ ?>